<?php
// Adds widget: WooFood Mini Cart
class Woofoodminicart_Widget extends WP_Widget {

  function __construct() {
    parent::__construct(
      'woofoodminicart_widget',
      esc_html__( 'WooFood Mini Cart', 'woofood-plugin' ),
      array( 'description' => esc_html__( 'Add WooFood cart Widget', 'woofood-plugin' ), ) // Args
    );
  }

  private $widget_fields = array(
  /*  array(
      'label' => 'Cart Title',
      'id' => 'carttitle_text',
      'type' => 'text',
    ),*/
  );

  public function widget( $args, $instance ) {
    echo $args['before_widget'];

   // echo woofood_cart($atts, null);
    echo do_shortcode('[woofood_cart cart_title="'.esc_html($instance['title']).'"]');

    
    echo $args['after_widget'];
  }

  public function field_generator( $instance ) {
    $output = '';
    foreach ( $this->widget_fields as $widget_field ) {
      $default = '';
      if ( isset($widget_field['default']) ) {
        $default = $widget_field['default'];
      }
      $widget_value = ! empty( $instance[$widget_field['id']] ) ? $instance[$widget_field['id']] : esc_html__( $default, 'woofood-plugin' );
      switch ( $widget_field['type'] ) {
        default:
          $output .= '<p>';
          $output .= '<label for="'.esc_attr( $this->get_field_id( $widget_field['id'] ) ).'">'.esc_attr( $widget_field['label'], 'woofood-plugin' ).':</label> ';
          $output .= '<input class="widefat" id="'.esc_attr( $this->get_field_id( $widget_field['id'] ) ).'" name="'.esc_attr( $this->get_field_name( $widget_field['id'] ) ).'" type="'.$widget_field['type'].'" value="'.esc_attr( $widget_value ).'">';
          $output .= '</p>';
      }
    }
    echo $output;
  }

  public function form( $instance ) {
    $title = ! empty( $instance['title'] ) ? $instance['title'] : esc_html__( '', 'woofood-plugin' );
    ?>
    <p>
      <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_attr_e( 'Title:', 'woofood-plugin' ); ?></label>
      <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
    </p>
    <?php
    $this->field_generator( $instance );
  }

  public function update( $new_instance, $old_instance ) {
    $instance = array();
    $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
    foreach ( $this->widget_fields as $widget_field ) {
      switch ( $widget_field['type'] ) {
        default:
          $instance[$widget_field['id']] = ( ! empty( $new_instance[$widget_field['id']] ) ) ? strip_tags( $new_instance[$widget_field['id']] ) : '';
      }
    }
    return $instance;
  }
}

function register_woofoodminicart_widget() {
  register_widget( 'Woofoodminicart_Widget' );
}
add_action( 'widgets_init', 'register_woofoodminicart_widget' );
?>