/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { BlockControls, InspectorControls, ServerSideRender, PlainText, MediaUpload, PanelColorSettings } from '@wordpress/editor';
import {
	Button,
	Disabled,
	PanelBody,
	Placeholder,
	RangeControl,
	Toolbar,
	TextControl,
	withSpokenMessages,
  SelectControl,
} from '@wordpress/components';
import { Component, Fragment } from '@wordpress/element';
import PropTypes from 'prop-types';
import Style from 'style-it';

/**
 * Internal dependencies
 */
import GridContentControl from '../../components/grid-content-control';
import { IconWidgets } from '../../components/icons';
import ProductsControl from '../../components/products-control';
import ProductOrderbyControl from '../../components/product-orderby-control';

/**
 * Component to handle edit mode of "Hand-picked Products".
 */
class WooFoodTabsHandpicked extends Component {
constructor() {
  			super( ...arguments );
	 this.state = {
    selectedTabIndex: 0,
 };
}
  
	getInspectorControls() {
		const { attributes, setAttributes } = this.props;
		const { columns, contentVisibility, orderby } = attributes;


	const onChangeTitle = ( title ) =>  {
 

  setAttributes({
      tabs: attributes.tabs.map((tab, i) => {
        if (i === this.state.selectedTabIndex) {
          return {
            ...tab,
            title,
          };
        }

        return tab;
      }),
    });
  };

		const onChangeTabs = ( number ) => {


       // We don't allow less than 1 tab
    if (number === 0) {
      return;
    }

    const tabItem = {
      align: '',

		/**
		 * Number of columns.
		 */

		/**
		 * Toggle for edit mode in the block preview.
		 */
		editMode: true,

		/**
		 * Content visibility setting
		 */
		contentVisibility: {
				title: true,
				price: true,
				rating: true,
				button: true,
			},

		/**
		 * How to order the products: 'date', 'popularity', 'price_asc', 'price_desc' 'rating', 'title'.
		 */
		order_by: 'date',
    order: 'ASC',

		/**
		 * The list of product IDs to display
		 */
		products: [],
		title:'Tab Name',
    BackgroundColor: '',
    titleTextColor: '#00000',
    borderColor: '#cc0000',
    icon: ''

    };

    if (number > attributes.tabs.length) {
      setAttributes({
        tabs: [...attributes.tabs, tabItem],
      });
    }

    if (number < attributes.tabs.length) {
      setAttributes({
        tabs: attributes.tabs.slice(0, number),
      });
    }


    };

		return (
			<InspectorControls key="inspector">
			 <TextControl
      label={ __( 'Tabs', 'woofood' ) }
        value={ attributes.tabs.length }
        onChange={ onChangeTabs }
        help={ __( 'Set how many tabs you want', 'woofood' ) }
        type ="number"
         />
          <PanelColorSettings
              title={__('Tab Color Settings', 'woofood')}
              initialOpen={true}
              colorSettings={[

              	{
                  value: this.props.attributes.tabs[this.state.selectedTabIndex].titleTextColor,
              onChange: value =>
                    	setAttributes({
     titleTextColor:value
    }),
                  label: __('Title Text Color', 'woofood'),
                },
                {
                  value: this.props.attributes.BackgroundColor,
                  onChange: BackgroundColor =>
                    	setAttributes({
     BackgroundColor:BackgroundColor
    }),
                  label: __(' Background Color', 'woofood'),
                }
                ,
                {
                  value: this.props.attributes.tabs[this.state.selectedTabIndex].borderColor,
               onChange: value =>
                    	setAttributes({
     borderColor:value
    }),
                  label: __('Hover Underline Color', 'woofood'),
                },
              ]}
            />


<PanelBody title={ __( 'Tab Item Settings', 'woofood' ) } >
      <TextControl
        label={ __( 'Tab Title', 'woofood' ) }
        value={ attributes.tabs[this.state.selectedTabIndex].title }
        onChange={ onChangeTitle }
        help={ __( 'Set the accordion title', 'woofood' ) }
      />
      <RangeControl
						label={ __( 'Columns', 'woofood' ) }
						value={ this.props.attributes.tabs[this.state.selectedTabIndex].columns }
						onChange={ ( columns ) => setAttributes({
      tabs: attributes.tabs.map((tab, i) => {
        if (i === this.state.selectedTabIndex) {
          return {
            ...tab,
            columns,
          };
        }

        return tab;
      }),
    }) }
						min={ wc_product_block_data.min_columns }
						max={ wc_product_block_data.max_columns }
					/>
        <strong>{ __( 'Order By', 'woofood' ) }</strong>

    <SelectControl
      label={ __( 'Order products by', 'woo-gutenberg-products-block' ) }
      value={ this.props.attributes.tabs[this.state.selectedTabIndex].order_by }
      options={ [
        {
          label: __( 'Date', 'woo-gutenberg-products-block' ),
          value: 'date',
        },
        {
          label: __( 'Price', 'woo-gutenberg-products-block' ),
          value: 'price',
        },
     
        {
          label: __( 'Title', 'woo-gutenberg-products-block' ),
          value: 'title',
        },
        {
          label: __( 'Menu Order', 'woo-gutenberg-products-block' ),
          value: 'menu_order',
        },
      ] }
      onChange={ ( order_by ) => setAttributes({
      tabs: attributes.tabs.map((tab, i) => {
        if (i === this.state.selectedTabIndex) {
          return {
            ...tab,
            order_by,
          };
        }

        return tab;
      }),
    }) }
    />
     <SelectControl
      label={ __( 'Order', 'woo-gutenberg-products-block' ) }
      value={ this.props.attributes.tabs[this.state.selectedTabIndex].order }
      options={ [
        {
          label: __( 'ASC' ),
          value: 'ASC',
        },
        {
          label: __( 'DESC' ),
          value: 'DESC',
        }
      ] }
      onChange={ ( order ) => setAttributes({
      tabs: attributes.tabs.map((tab, i) => {
        if (i === this.state.selectedTabIndex) {
          return {
            ...tab,
            order,
          };
        }

        return tab;
      }),
    }) }
    />





            <strong>{ __( 'Products', 'woofood' ) }</strong>

<ProductsControl
						selected={ this.props.attributes.tabs[this.state.selectedTabIndex].products }
						onChange={ ( value = [] ) => {
							const products = value.map( ( { id } ) => id );

							setAttributes({
      tabs: attributes.tabs.map((tab, i) => {
        if (i === this.state.selectedTabIndex) {
          return {
            ...tab,
            products,
          };
        }

        return tab;
      }),
    });

						} 



					}
					/>


         <PanelColorSettings
              title={__('Tab Item Colors', 'woofood')}
              initialOpen={false}
              colorSettings={[
                {
                  value: this.props.attributes.tabs[this.state.selectedTabIndex].BackgroundColor,
                  onChange: BackgroundColor =>
                    	setAttributes({
      tabs: attributes.tabs.map((tab, i) => {
        if (i === this.state.selectedTabIndex) {
          return {
            ...tab,
            BackgroundColor,
          };
        }

        return tab;
      }),
    }),
                  label: __(' Background Color', 'woofood'),
                },
                {
                  value: this.props.attributes.tabs[this.state.selectedTabIndex].titleTextColor,
                onChange: titleTextColor =>
                    	setAttributes({
      tabs: attributes.tabs.map((tab, i) => {
        if (i === this.state.selectedTabIndex) {
          return {
            ...tab,
            titleTextColor,
          };
        }

        return tab;
      }),
    }),
                  label: __('Title Text Color', 'woofood'),
                },
                {
                  value: this.props.attributes.tabs[this.state.selectedTabIndex].borderColor,
                onChange: borderColor =>
                    	setAttributes({
      tabs: attributes.tabs.map((tab, i) => {
        if (i === this.state.selectedTabIndex) {
          return {
            ...tab,
            borderColor,
          };
        }

        return tab;
      }),
    }),
                  label: __('Border Color', 'woofood'),
                },
              ]}
            />      
    </PanelBody>
        <strong>{ __( 'Icon Settings', 'woofood' ) }</strong>


                    <img src={this.props.attributes.tabs[this.state.selectedTabIndex].icon} alt="" />

 <MediaUpload

           onSelect={(imageObject) => (
            console.log(imageObject),
              setAttributes({
      tabs: attributes.tabs.map((tab, i) => {
        if (i === this.state.selectedTabIndex) {
          return {
            ...tab,
            icon:imageObject.sizes.full.url,
          };
        }

        return tab;
      }),
    })


           )}

           
            type="image"
            //value={backgroundImage} // make sure you destructured backgroundImage from props.attributes!
            render={({ open }) => (
              <div>
                <button onClick={open}>
                    { __( 'Upload Icon', 'woofood' ) }
                </button>
                  <button onClick={(imageObject) => (
            console.log(imageObject),
              setAttributes({
      tabs: attributes.tabs.map((tab, i) => {
        if (i === this.state.selectedTabIndex) {
          return {
            ...tab,
            icon:'',
          };
        }

        return tab;
      }),
    })


           )} >
                    { __( 'Remove Icon', 'woofood' ) }
                </button>
                </div>

            )}
        />

     

				
			</InspectorControls>
		);
	}

	renderEditMode() {
		const { attributes, debouncedSpeak, setAttributes } = this.props;
		const onDone = () => {
			var  editMode =  false;
				setAttributes({
      tabs: attributes.tabs.map((tab, i) => {
        if (i === this.state.selectedTabIndex) {
          return {
            ...tab,
            editMode,
          };
        }

        return tab;
      }),
    });


			//setAttributes( { editMode: false } );
			debouncedSpeak(
				__(
					'Showing Hand-picked Products block preview.',
					'woo-gutenberg-products-block'
				)
			);
   /*var s = document.createElement( 'script' );
  s.setAttribute( 'src', woofood_plugin_tabs_js_url );
  document.body.appendChild( s );*/

		};

		return (
			<Placeholder
				icon={ <IconWidgets /> }
				label={ __( 'Hand-picked Products', 'woo-gutenberg-products-block' ) }
				className="wc-block-products-grid wc-block-handpicked-products"
			>
				{ __(
					'Display a selection of hand-picked products in a grid',
					'woo-gutenberg-products-block'
				) }
				<div className="wc-block-handpicked-products__selection">
					<ProductsControl
						selected={ this.props.attributes.tabs[this.state.selectedTabIndex].products }
						onChange={ ( value = [] ) => {
							const products = value.map( ( { id } ) => id );

							setAttributes({
      tabs: attributes.tabs.map((tab, i) => {
        if (i === this.state.selectedTabIndex) {
          return {
            ...tab,
            products,
          };
        }

        return tab;
      }),
    });

						} 



					}
					/>
					<Button isDefault onClick={ onDone }>
						{ __( 'Done', 'woo-gutenberg-products-block' ) }
					</Button>
				</div>
			</Placeholder>
		);
	}

	render() {
		const { attributes, setAttributes } = this.props;
		const  editMode  = attributes.tabs[this.state.selectedTabIndex].editMode;
    const  currentEditMode  = attributes.tabs[this.state.selectedTabIndex].editMode;

    const onEditModeClick = () => {
      var  editMode =  true;
      if(currentEditMode ===false)
      {
        editMode =  true;
        }
          else
          {
            editMode =  false;

          }

        setAttributes({
          editMode: ! currentEditMode,
    
      tabs: attributes.tabs.map((tab, i) => {
        if (i === this.state.selectedTabIndex) {
          return {
            ...tab,
            editMode,
          };
        }

        return tab;
      }),
    });


    
    };

		return (
			<Fragment>
				<BlockControls>
					<Toolbar
						controls={ [
							{
								icon: 'edit',
								title: __( 'Edit' ),
								onClick: () => onEditModeClick(),
								isActive: editMode,
							},
						] }
					/>
				</BlockControls>

				{ this.getInspectorControls() }
				{ editMode ? (
					this.renderEditMode()
				) : (
				console.log(this.props.attributes),

<div className="woofood-block-tabs-edit">
    <Style>
          {`   


         .woofood-tabs-menu .nav-item a {
 	
 	color: ${ attributes.titleTextColor };
  text-decoration: none;
  background: ${ attributes.BackgroundColor };
  display: inline-block;
  padding: 15px 20px;
  position: relative;
}
.woofood-tabs-menu .nav-item a:after {    
  background: none repeat scroll 0 0 transparent;
  bottom: 0;
  content: "";
  display: block;
  height: 3px;
  left: 50%;
  position: absolute;
  background: ${ attributes.borderColor };
  transition: width 0.5s ease 0s, left 0.5s ease 0s;
  width: 0;
}
.woofood-tabs-menu .nav-item a:hover:after, .woofood-tabs-menu .nav-item .active:after  { 
  width: 100%; 
  left: 0; 
}
 .woofood-tabs-menu .nav-item a:before {
  content: "";
  position: absolute;
  width: 100%;
  height: 3px;
  bottom: 0;
  left: 0;
  background: #9CF5A6;
  visibility: hidden;
  border-radius: 5px;
  transform: scaleX(0);
  transition: .25s linear;
}
        
         `}
        </Style>

	<ul className="nav justify-content-center woofood-tabs-menu">
								
{this.props.attributes.tabs.map((tab, index)  => (
<li className="nav-item"   onClick={() => {
                    this.setState(() => ({
                      selectedTabIndex: index,
                    }));
                  }}>
    <a className={index ==0 ? 'nav-link active show' : 'nav-link'} data-toggle="tab" role="tab" aria-controls={(encodeURIComponent('wf-tab-'+index)).replace(/%/g,'')} id={(encodeURIComponent('nav-wf-tab-'+index)).replace(/%/g,'')} target={'#'+(encodeURIComponent('wf-tab-'+index)).replace(/%/g,'')} style={{
              background: this.props.attributes.tabs[index].BackgroundColor || undefined,
              borderColor: this.props.attributes.tabs[index].borderColor || undefined,
            }} onClick={() => {
                    this.setState(() => ({
                      selectedTabIndex: index,
                    }));
                  }}
            >
                  { !! this.props.attributes.tabs[index].icon.length > 0 &&  <img src={this.props.attributes.tabs[index].icon} /> }

     <PlainText
            
       onChange={(title) => { setAttributes({
      tabs: attributes.tabs.map((tab, i) => {
        if (i === this.state.selectedTabIndex) {
          return {
            ...tab,
            title,
          };
        }

        return tab;
      }),
    }) } }
onFocus={() => {
                    this.setState(() => ({
                      selectedTabIndex: index,
                    }));
                  }}
                value={this.props.attributes.tabs[index].title}
                style={{ color: this.props.attributes.tabs[index].titleTextColor || undefined}}
                /> </a>
  </li>
 ))}
</ul>
<ServerSideRender block="woofood/tabs-handpicked" attributes={ attributes }/>
</div>









				) }
			</Fragment>
		);
	}
}

WooFoodTabsHandpicked.propTypes = {
	/**
	 * The attributes for this block
	 */
	attributes: PropTypes.object.isRequired,
	/**
	 * The register block name.
	 */
	name: PropTypes.string.isRequired,
	/**
	 * A callback to update attributes
	 */
	setAttributes: PropTypes.func.isRequired,
	// from withSpokenMessages
	debouncedSpeak: PropTypes.func.isRequired,
};

export default withSpokenMessages( WooFoodTabsHandpicked );
